import 'package:flutter/cupertino.dart';
import 'package:flutter/services.dart';

class RevenueFloFlutter {
  // Define a MethodChannel to communicate with iOS native code
  static const MethodChannel _channel = MethodChannel('com.revenueflo.swift.sdk/native');

  // Method to call the 'configure' function in the Swift singleton
  static Future<String> configure() async {
    try {
      // Call the native function and return the result
      final String result = await _channel.invokeMethod('configureRevenueFlo');
      return result;
    } catch (e) {
      // Handle any errors that might occur during communication
      debugPrint('Error calling configure: $e');
      return 'Error';
    }
  }

  static Future<void> presentOffer({double delay = 0.0}) async {
    try {
      await _channel.invokeMethod('presentOffer', {'delay': delay});
    } catch (e) {
      debugPrint("Error invoking presentOffer: $e");
    }
  }

  static void setDelegateListeners({
    required Function(String offer) onOfferDidPresent,
    required Function(String offer) onOfferDidClose,
    required Function(String offer) onOfferPrimaryButtonDidClick,
  }) {
    _channel.setMethodCallHandler((call) async {
      switch (call.method) {
        case "offerDidPresent":
          onOfferDidPresent(call.arguments);
          break;
        case "offerDidClose":
          onOfferDidClose(call.arguments);
          break;
        case "offerPrimaryButtonDidClick":
          onOfferPrimaryButtonDidClick(call.arguments);
          break;
        default:
          debugPrint("Unhandled method: ${call.method}");
      }
    });
  }

}
